var topic = "<!DOCTYPE html>\r\n\n<!-- saved from url=(0024)http://docs.autodesk.com -->\r\n<html>\n   <head>\n      <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">\n      <meta name=\"product\" content=\"MAYAUL\">\n      <meta name=\"release\" content=\"2016\">\n      <meta name=\"book\" content=\"Tutorial\">\n      <meta name=\"created\" content=\"2015-10-30\">\n      <meta name=\"topicid\" content=\"GUID-86028399-9377-4D8D-9B26-D883244008CE\">\n      <meta name=\"topic-type\" content=\"concept\">\n      <title>Lesson 5: Simulating medium resolution meshes using custom nCloth attribute presets</title><script language=\"javascript\">var index = \'index.html\';</script></head>\n   <body height=\"100%\">\n      <div class=\"body_content\" id=\"body-content\" dir=\"ltr\"><a name=\"GUID-86028399-9377-4D8D-9B26-D883244008CE\"></a><div class=\"head\">\n            <h1>Lesson 5: Simulating medium resolution meshes using custom nCloth attribute presets</h1>\n         </div>\n         <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-769F\"></a>Now that you have used the workflow in Lessons 3 and 4 to realistically solve the\n            low resolution nCloth meshes, you can use them to quickly prepare a medium resolution\n            version of the nCloth pants and shirt for simulation. \n            	 \n         </p>\n         <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-769E\"></a>In this lesson, you will: \n            	 \n         </p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-769D\"></a><ul>\n            <li>Save the nCloth attributes for the Shirt_LowRes and Pants_LowRes objects as custom\n               nCloth presets. \n               		\n            </li>\n            <li>Change the \n               		  <span class=\"MenuCascade\" id=\"GUID-01325031-6745-423C-9FF6-FB715BEEBDE4\">Scaling Relation</span> attribute and observe its impact on the nCloth simulated meshes. \n               		\n            </li>\n         </ul>\n         <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-769A\"></a> \n            <h2><a name=\"GUID-E689E972-06AB-470C-B300-C173C92D771D\"></a>Lesson Setup\n            </h2> <a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3415\"></a><ol type=\"1\" start=\"1\">\n               <li>If you have not already done so, download the nCloth Advanced Techniques Lesson Data\n                  from the following location: \n                  			 <a href=\"http://www.autodesk.com/maya-advancedtechniques\" target=\"_blank\">http://www.autodesk.com/maya-advancedtechniques</a>. Then, set the \n                  			 <span class=\"code\">nClothAdvancedTutorials</span> directory as your Maya project. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3413\"></a>For this lesson, you need to access Maya geometry cache files in addition to the lesson\n                     scene file. \n                     			 \n                  </p> \n               </li>\n               <li>Open the scene file named \n                  			 <span class=\"code\">Character_MedRes.mb</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3411\"></a>This file can be found in the \n                     				<span class=\"code\">nClothAdvancedTutorials</span> directory that you set as your Maya project. \n                     			 \n                  </p> \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-3410\"></a>The medium resolution shirt and pant meshes have already been converted to nCloth\n                     objects and named nCloth_Shirt_MedResShape and nCloth_Pants_MedResShape. \n                     			 \n                  </p> \n                  <p><a name=\"WS1A9193826455F5FF-4855151011E1D0EC60D-340F\"></a> A<span class=\"MenuCascade\" id=\"GUID-E189CB25-D15C-4139-A792-6835CA3B9786\"> Point to Surface</span> constraint has been applied to the pants to constrain them to the character\'s waist.\n                     The medium resolution shirt and pants have already been wrapped (using a wrap deformer)\n                     with a new, duplicated high resolution shirt and pants mesh. The low resolution shirt\n                     and pants, and the nCloth shirt and nCloth pants objects have been cached and are\n                     positioned next to the medium resolution meshes for reference. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E13\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-A13C57BE-338C-499F-9087-392A773F2890-low.png\"></div> \n               </li>\n               <li>Import the geometry caches which animate the character’s body and shoes for the low\n                  resolution and medium resolution characters. See \n                  			 <span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3429\">Importing geometry caches</a></span>. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62D4\"></a> \n            <h2><a name=\"GUID-BF21704D-92A8-43E7-8819-57B15DE2BC29\"></a>Save the nCloth attributes as custom presets\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62D3\"></a>By the end of Lesson 3 and 4, you generated optimized simulations of your character’s\n               shirt and pants. A number of steps were involved in obtaining the attribute values\n               that drive the behavior of these nCloth objects, and so you may want to save these\n               optimized attribute values. \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF-4F6D1F1D11D24BE3E03BDF\"></a>Using Maya attribute presets, you can save the attribute values of the low resolution\n               nCloth shirt (nCloth_ShirtShape) and nCloth pants (nCloth_PantsShape) objects as custom\n               nCloth presets. Your new nCloth presets can then be applied to other versions of the\n               meshes, including the medium resolution shirt and pants. This workflow allows you\n               to quickly prepare other simulations with geometry that has similar topology to your\n               original objects. \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62D2\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62D1\"></a>To save the nCloth shirt object\'s attributes as a custom nCloth preset\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the scene view, select the low resolution nCloth shirt. \n                  		  \n               </li>\n               <li>In the<span class=\"MenuCascade\" id=\"GUID-A5C442BF-FE46-48DB-8077-51BDDA79E55E\"> Attribute Editor</span>, click the \n                  			 <span class=\"MenuCascade\" id=\"GUID-36FEE820-2AC4-4A72-B771-E8964AE70C9B\">nCloth_ShirtShape</span> tab. \n                  		  \n               </li>\n               <li>Click-hold the \n                  			 <span class=\"MenuCascade\" id=\"GUID-B7C324DD-C32E-441F-93E1-28910C9A442D\">Presets</span> button. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62CD\"></a>The nCloth attribute \n                     				<span class=\"MenuCascade\" id=\"GUID-9F60DFE3-927D-4F26-A349-8287DFDD5918\">Presets</span> pop-up menu appears. \n                     			 \n                  </p> \n               </li>\n               <li>Select \n                  			 <span class=\"MenuCascade\" id=\"GUID-05CAB1E4-5253-4693-AF21-4C20441CB362\">Save nCloth Preset</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-62CB\"></a>The \n                     				<span class=\"MenuCascade\" id=\"GUID-2334E0CE-8FD4-4BD0-BAE7-7EC4D52C88AF\">Save Attribute Preset \n                        				</span>window appears. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E12\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-CDC91350-AF1E-4D6E-9774-88CB3BAD4132-low.png\"></div> \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-4972956E-1DAB-44AB-BC9C-37602921CCC3\">Preset name</span> field type \n                  			 <em class=\"mild\">nCloth_ShirtShape</em> for the name of the custom attribute preset you want to create, and then click<span class=\"MenuCascade\" id=\"GUID-7DFEAD89-5812-4976-9F7B-39372DC3BCAF\"> Save Attribute Preset</span>. \n                  		  \n               </li>\n               <li>Repeat steps 1 to 5 to save the nCloth pants as a custom nCloth attribute preset \n                  			 <em class=\"mild\">nCloth_PantsShape</em>. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-620A\"></a> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-6209\"></a>Since you no longer need to simulate the low resolution nCloth shirt and pants, you\n               can disable them from the Nucleus solver. Doing this increases the simulation speed\n               of your medium resolution nCloth shirt and pants. \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-6208\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-6207\"></a>To disable the low resolution nCloth shirt and pants\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the scene view, select the low resolution nCloth shirt. \n                  		  \n               </li>\n               <li>In the<span class=\"MenuCascade\" id=\"GUID-0778C47E-E433-40E2-A463-5C625D51FE7B\"> Attribute Editor</span>, click the \n                  			 <span class=\"MenuCascade\" id=\"GUID-099FF7AA-25F6-4DB7-99F6-FA67A7D6409E\">nCloth_ShirtShape</span> tab. \n                  		  \n               </li>\n               <li>Turn off \n                  			 <span class=\"MenuCascade\" id=\"GUID-515A50AA-7CFD-4BC6-86A8-728A786C2358\">Enable</span>. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E11\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-DA62070A-A6E6-4566-84F9-95289AAB5252-low.png\"></div> \n               </li>\n               <li>Repeat steps 1 to 3 for the nCloth pants object. \n                  		  \n               </li>\n               <li>Hide the low resolution character and clothing by selecting \n                  			 <em class=\"mild\">Character_LowRes</em> in the<span class=\"MenuCascade\" id=\"GUID-ADEAC1A2-93F2-453F-B7C8-CB9CFFD7E457\"> Outliner</span> and then selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-0662FD00-7F80-4FFD-AA3B-C7B53B882674\">Display &gt; Hide &gt; Hide Selection</span>. \n                  		  \n               </li>\n            </ol> \n         </div>\n         <div class=\"section\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7693\"></a> \n            <h2><a name=\"GUID-3B1C4B20-6F7C-47FB-AC18-323649798325\"></a>Applying the custom nCloth attribute preset to the medium resolution shirt and pants\n            </h2> \n            <p><a name=\"WS73099CC142F48755-1EB804411AF8B41570-6E34\"></a>In this lesson, you apply your custom nCloth attribute presets to the medium resolution\n               versions of the nCloth shirt and pants (nCloth_Shirt_MedResShape and nCloth_Pants_MedResShape).\n               After the attribute presets are applied, you can fine tune the simulation by adjusting\n               the \n               		  <span class=\"MenuCascade\" id=\"GUID-7980392C-2A28-4D12-BB25-2EB7B3A07B9E\">Collisions</span>,<span class=\"MenuCascade\" id=\"GUID-97372ECA-5053-489B-B697-A611681E32A0\"> Dynamic Properties</span>, and \n               		  <span class=\"MenuCascade\" id=\"GUID-28C6A578-FD09-4286-85C6-B6BAD29E0ECC\">Quality Setting</span> attributes. \n               		\n            </p> \n         </div><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7692\"></a><p class=\"list-intro\"><a name=\"WS73099CC142F48755-1EB804411AF8B41570-7691\"></a>To apply your custom nCloth attribute preset to the medium resolution nCloth\n         </p>\n         <ol type=\"1\" start=\"1\">\n            <li>In the scene view, select the nCloth medium resolution shirt. \n               		\n            </li>\n            <li>In the<span class=\"MenuCascade\" id=\"GUID-BE8888A2-97E6-43A0-BB1C-D6AC219D7D2F\"> Attribute Editor</span>, click the \n               		  <span class=\"MenuCascade\" id=\"GUID-54CD4B03-2A61-4177-954D-DDB8B7B205D8\">nCloth_Shirt_MedResShape</span> tab. \n               		\n            </li>\n            <li>Click-hold the \n               		  <span class=\"MenuCascade\" id=\"GUID-4F93CD56-2DAD-4446-B0CB-F6053DF36215\">Presets \n                  		  </span>button, select the \n               		  <span class=\"MenuCascade\" id=\"GUID-B819E9EE-0AB4-4DC9-B0F0-9F0486C9FCF0\">nCloth_ShirtShape \n                  		  </span>preset, and select \n               		  <span class=\"MenuCascade\" id=\"GUID-C3D31CF2-1B64-421B-85ED-B02345A6DB5A\">Replace</span>. \n               		\n            </li>\n            <li>In the scene view, select the medium resolution nCloth pants. \n               		\n            </li>\n            <li>In the \n               		  <span class=\"MenuCascade\" id=\"GUID-7692D71F-C12A-45DD-A372-1957958C2E15\">Attribute Editor</span>, click the \n               		  <span class=\"MenuCascade\" id=\"GUID-FDA73591-C738-45B8-B0F0-E72B60683F03\">nCloth_Pants_MedResShape</span> tab select the \n               		  <span class=\"MenuCascade\" id=\"GUID-603A7817-E27A-491E-A2B4-D6EA5D5EBFAA\">nCloth_PantsShape</span> preset, and select \n               		  <span class=\"MenuCascade\" id=\"GUID-22266F07-2B75-44B9-8E4E-E683BB324AA4\">Replace</span>. \n               		\n            </li>\n            <li>In the scene view, Shift-select the medium resolution nCloth shirt and pants, and\n               create a new cache by selecting \n               		  <span class=\"MenuCascade\" id=\"GUID-09BD4E44-9ED9-4BF0-A607-6526816CA416\">nCache &gt; Create New Cache &gt; nObject</span>. \n               		  \n               <p><a name=\"WS73099CC142F487551A80AE1B11E21F4DA0C-18C2\"></a>The nCloth shirt and pants simulations are saved in one nCache file. \n                  		  \n               </p> \n            </li>\n            <li>Play back the simulation. \n               		\n            </li>\n         </ol>\n         <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-61FF\"></a> \n            <h2><a name=\"GUID-E14AF077-63CE-43C0-A238-60848D6AFFB6\"></a>Comparing the final simulations\n            </h2> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-61FE\"></a>In the final sections of this lesson, you compare your final nCloth simulations. First,\n               you compare the behavior of your medium resolution nCloth shirt and pant objects with\n               your final low resolution shirt and pants simulations. This comparison allows you\n               to see differences in the way the high resolution mesh behaves when it is wrapped\n               on low and medium resolution meshes. In the last section, you compare all three simulation\n               versions of nCloth (the original high resolution, medium resolution, and low resolution\n               meshes). \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D5F\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D5E\"></a>To compare your medium and low resolution simulations\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>Hide the \n                  			 <em class=\"mild\">Shirt_MedRes</em>, \n                  			 <em class=\"mild\">Pants_MedRes</em>, \n                  			 <em class=\"mild\">Shirt_LowRes</em>, and \n                  			 <em class=\"mild\">Pants_LowRes</em> objects by selecting them in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-7BD0E44F-C2C1-4EBD-81D5-32ABB1612B7D\">Outliner</span>, and then selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-3FE18E63-3B9C-41DD-899F-799A80A3F100\">Display &gt; Hide &gt; Hide Selection</span>. \n                  		  \n               </li>\n               <li>Show all the objects in the \n                  			 <em class=\"mild\">Character_HighRes</em> group by selecting \n                  			 <em class=\"mild\">Pants_HighRes</em> and \n                  			 <em class=\"mild\">Shirt_HighRes</em> as well as \n                  			 <em class=\"mild\">Character_LowRes</em> in the \n                  			 <span class=\"MenuCascade\" id=\"GUID-FBA10192-2BB4-43FE-A8C1-EF965B8AA00D\">Outliner</span>, and then selecting \n                  			 <span class=\"MenuCascade\" id=\"GUID-ED3EC6AE-17C6-4E4C-877E-2FB9784E200A\">Display &gt; Show &gt; Show Selection</span>. \n                  			 \n                  <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D5B\"></a>The medium resolution and low resolution nCloth meshes, each wrapped by the same high\n                     resolution shirt and pants, now appear in the scene view. \n                     			 \n                  </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E10\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-BD7B17FC-927F-4EDC-96AA-ADF81AE89701-low.png\"></div> \n               </li>\n               <li>Play back the scene. \n                  		  \n               </li>\n            </ol> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D59\"></a>Dolly and tumble the scene while scrubbing the \n               		  <span class=\"MenuCascade\" id=\"GUID-D6A1D44E-64AD-4B92-8B6A-B12EB2B793F9\">Time Slider</span> so that you can closely observe any differences in the behavior of each nCloth object.\n               \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D58\"></a>When you play back the simulations, you notice the following: \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D57\"></a><ul>\n               <li>The low and medium resolution shirts are behaving in the same way. \n                  		  \n               </li>\n               <li>The medium resolution pants are taking more time than the low resolution pants to\n                  settle in the first frames of the simulation. \n                  		  \n               </li>\n               <li>Between frame 1040 and 1045, the medium resolution pants ride further up on the character\n                  legs than the low resolution pants. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E0F\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-5D792F65-96C4-4215-A6FE-CF2B977F3157-low.png\"></div> \n               </li>\n               <li> At frame 1047, the cuffs of the medium resolution pants are further apart than the\n                  cuffs of the low resolution pants. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E0E\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-EEEA6FBE-CC83-4EC3-8FE0-A17A23CF123D-low.png\"></div> \n               </li>\n               <li>The medium resolution pants appear to have more bounce during specific areas of the\n                  simulation. \n                  		  \n               </li>\n            </ul> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D51\"></a>If you are not satisfied with the behavior of your medium resolution nCloth shirt\n               and pants, use the same attribute optimizing workflow described in Lessons 3 and 4\n               to adjust the \n               		  <span class=\"MenuCascade\" id=\"GUID-D97C1235-6FF1-4E51-AC8E-7BF56D5B9436\">Collisions</span>, \n               		  <span class=\"MenuCascade\" id=\"GUID-BB4D677B-2B42-4B2E-9E87-5AD5830C0C5A\">Dynamic Properties</span>, and \n               		  <span class=\"MenuCascade\" id=\"GUID-03366B4D-4499-40C6-9902-36B2A50E46B3\">Quality Settings</span> attributes. \n               		\n            </p> \n            <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D50\"></a>You can remove some of the bounce from the medium resolution nCloth pants by editing\n               the \n               		  <span class=\"MenuCascade\" id=\"GUID-E40DBB7F-3A24-4CB6-914D-B2592736BA2E\">Scaling Relation</span> attribute. When \n               		  <span class=\"MenuCascade\" id=\"GUID-CF6DA2DD-B788-4724-BA68-98E4534DA679\">Scaling Relation</span> is set to \n               		  <span class=\"MenuCascade\" id=\"GUID-283761C9-9F1F-470A-AF70-8573DA27BD4D\">Link</span>, the nCloth’s dynamic attributes, such as \n               		  <span class=\"MenuCascade\" id=\"GUID-309F9685-1A1F-41ED-8A43-192D3A5D8D3F\">Bend Resistance</span> and \n               		  <span class=\"MenuCascade\" id=\"GUID-5F81B0F2-D231-4A02-8E16-B117308BE875\">Stretch Resistance</span> are calculated relative to the mesh’s scale. When \n               		  <span class=\"MenuCascade\" id=\"GUID-56F9BE96-91CF-42BC-8AD8-1BE682BA43FE\">Scaling Relation</span> is set to \n               		  <span class=\"MenuCascade\" id=\"GUID-1DD92E57-04CD-46AC-BF3D-A8BE3D40A6CB\">Object</span>, the dynamic attribute calculations are automatically scaled based on the mesh’s\n               resolution. Low resolution meshes tend to stretch more when \n               		  <span class=\"MenuCascade\" id=\"GUID-418305DC-EB43-4BA9-8101-8A78883D15CC\">Scaling Relation</span> is set to \n               		  <span class=\"MenuCascade\" id=\"GUID-47437884-A9EA-435C-9BE8-A88005F26285\">Object</span> rather than \n               		  <span class=\"MenuCascade\" id=\"GUID-CC93A890-E19C-40E1-BA9B-21746815DE0B\">Link</span>. High resolution meshes tend to stretch less when \n               		  <span class=\"MenuCascade\" id=\"GUID-37FB907E-8508-40A6-B782-5F23C09805D5\">Scaling Relation</span> is set to \n               		  <span class=\"MenuCascade\" id=\"GUID-B73ED43F-A184-46E6-8490-AF9AA4BD4B68\">Object</span> rather than if \n               		  <span class=\"MenuCascade\" id=\"GUID-CCA0857B-7DD1-438F-9263-E60CDC44E7FF\">Scaling Relation</span> is set \n               		  <span class=\"MenuCascade\" id=\"GUID-B74850B7-D7EC-406A-B380-A1228262AD62\">Link</span>. For more information, see \n               		  <em class=\"mild\">nCloth Dynamic Properties</em> in the Maya Help. \n               		\n            </p> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D4F\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D4E\"></a>To edit Scaling Relation\n            </p>\n            <ol type=\"1\" start=\"1\">\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-94006E7A-E063-40D1-8F26-F26D00DB59B1\">Outliner</span>, select the medium resolution nCloth pants. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-6537D6DB-C51C-411F-82AE-6C78F8E796A0\">Attribute Editor</span>, click the \n                  			 <span class=\"MenuCascade\" id=\"GUID-34B22B55-3034-4D56-BFCF-81186598655F\">nCloth_Pants_MedResShape</span> tab. \n                  		  \n               </li>\n               <li>In the \n                  			 <span class=\"MenuCascade\" id=\"GUID-EAADD624-6A26-44C4-87A2-54838AC72456\">Dynamic Properties</span> section, set \n                  			 <span class=\"MenuCascade\" id=\"GUID-F1487849-2C3F-4A9C-891E-239E35AC24A8\">Scaling Relation</span> to \n                  			 <span class=\"MenuCascade\" id=\"GUID-54AD4CA2-324E-41A0-9821-6ECD45FE3E88\">Object Space</span>. \n                  			 <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E0D\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-3B91FBA9-7931-4357-BBE7-AF58EEE0681F-low.png\"></div> \n               </li>\n               <li>Cache the simulation (<span class=\"MenuCascade\">nCache &gt; Create New Cache &gt; nObject</span>), and play it back. \n                  		  \n               </li>\n            </ol> \n            <div class=\"section\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D48\"></a> \n               <h3><a name=\"GUID-1860362E-366A-48C6-BF39-DC5BF792FDD8\"></a>Compare all three versions of nCloth\n               </h3> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D47\"></a><p class=\"list-intro\"><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D46\"></a>To compare all three versions of nCloth\n               </p>\n               <ol type=\"1\" start=\"1\">\n                  <li>Ensure that: \n                     				<a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D44\"></a><ul>\n                        <li>The Shirt_MedRes, Pants_MedRes, Shirt_LowRes, and Pants_LowRes objects are hidden.\n                           \n                           				  \n                        </li>\n                        <li>All objects in the Character_HighRes group are shown in the scene. \n                           				  \n                        </li>\n                     </ul> \n                  </li>\n                  <li>In the \n                     				<span class=\"MenuCascade\" id=\"GUID-7325F5FF-9FB1-4015-B43C-170E84DEC986\">Display Layer</span> editor, turn on Visible for the Reference_Character object in the scene view. \n                     			 \n                  </li>\n                  <li>Scrub through the \n                     				<span class=\"MenuCascade\" id=\"GUID-5E145D8F-BF49-4EC2-91AF-E17772D85C06\">Time Slider</span> to compare how the nCloth meshes behave in the animation. Dolly and tumble the scene\n                     so that you can closely observe any subtle differences in the nCloth. \n                     				\n                     <div><a name=\"WS73099CC142F487551A80AE1B11E21F4DA0C-18C0\"></a><div class=\"note-note\"><span class=\"label label-target-language\">NOTE:</span> \n                           <p><a name=\"GUID-EF57697D-4D20-4B37-8688-380792DE7880\"></a>If the Reference_Character is not animated in the scene view when you play back or\n                              scrub the simulation, you may need to reconnect the reference character’s caches to\n                              their respective objects. See \n                              					 <span class=\"char_link\"><a href=\"GUID-EFE22F39-CDF9-4CAD-BF42-10D3A8181EE0.htm#WS1A9193826455F5FF-4855151011E1D0EC60D-3426\">Reconnecting objects to existing caches</a></span>. \n                              				  \n                           </p> \n                        </div>\n                     </div> <a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-3E0C\"></a><div class=\"figure-anchor\"><img src=\"../images/GUID-CF6DAC51-16A3-4C1F-9741-F924604B7EE0-low.png\"></div> \n                  </li>\n               </ol> \n               <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D3F\"></a>When you compare the three versions of nCloth, you have to look closely to notice\n                  the subtle differences in behavior. Considering the amount of time saved optimizing\n                  a low resolution mesh, this workflow provides a viable alternative to simulating highly\n                  detailed character clothing. By wrapping your highly detailed mesh onto a lower resolution\n                  nCloth instead of simulating it, you can still model details into mesh without worrying\n                  about how it simulates. \n                  		  \n               </p> \n               <p><a name=\"WS1A9193826455F5FF5CF1D02511B1D000978-5D3E\"></a>By saving the low resolution nCloth attributes as a custom preset, you add value to\n                  the time invested in optimizing the nCloth simulation. After applying the preset to\n                  the medium resolution nCloth, only minimal adjustment is required to obtain a simulation\n                  with good results. \n                  		  \n               </p> \n            </div> \n         </div>\n         <div class=\"footer-block\"><a href=\"..\" class=\"comments-anchor\" target=\"_blank\"><span class=\"comments-link\">Please send us your comment about this page</span></a></div><br><p class=\"footer-license-block\"><a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\"><img alt=\"Creative Commons License\" style=\"border-width: 0;\" src=\"../images/ccLink.png\"></a>&nbsp;<em>Except where otherwise noted, this work is licensed under a <a rel=\"license\" href=\"http://creativecommons.org/licenses/by-nc-sa/3.0/\" target=\"_blank\">Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License</a>. Please see the <a href=\"http://autodesk.com/creativecommons\" target=\"_blank\">Autodesk Creative Commons FAQ</a> for more information.</em></p><br></div>\n   </body>\n</html>";